/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFType;
import fme.CFType_Valor0;
import fme.CHTabColModel;
import fme.CHTabQuadro;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_Accoes;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;

class CBTabela_DespFin
extends CBTabela {
    Frame_Accoes P = (Frame_Accoes)fmeFrame.Paginas.getPage("Accoes");
    int tab_index = 0;

    public String getPagina() {
        return "Accoes";
    }

    CBTabela_DespFin() {
        if (this.P == null) {
            return;
        }
        this.initialize();
    }

    void initialize() {
        this.tag = "DespFin";
        this.started = true;
        this.force_xml = true;
        this.cols = new CHTabColModel[6];
        this.cols[0] = new CHTabColModel("rubrica", "Rubrica (id)", true, false, false, null);
        this.cols[1] = new CHTabColModel("rubrica_d", "Rubrica", 2, false, true, null);
        this.cols[2] = new CHTabColModel("valor_f1", "Ano 1", true, CBData.Params.anos > 0, true, (CFType)new CFType_Valor0());
        this.cols[3] = new CHTabColModel("valor_f2", "Ano 2", true, CBData.Params.anos > 1, true, (CFType)new CFType_Valor0());
        this.cols[4] = new CHTabColModel("valor_f3", "Ano 3", true, CBData.Params.anos > 2, true, (CFType)new CFType_Valor0());
        this.cols[5] = new CHTabColModel("valor_tt", "Total", true, false, true, (CFType)new CFType_Valor0());
        this.init_dados(4);
        this.init_handler(new CHTabQuadro(), this.P.getJTable_DespFin());
        this.P.getJTable_DespFin().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P.getJScrollPane_DespFin().getWidth() - 2;
        this.cols[0].disable_row_calc = true;
        this.cols[1].disable_row_calc = true;
        ((CHTabQuadro)this.handler).start_rows();
        ((CHTabQuadro)this.handler).row_editable[0] = false;
        ((CHTabQuadro)this.handler).row_editable[1] = false;
        ((CHTabQuadro)this.handler).row_editable[2] = false;
        ((CHTabQuadro)this.handler).row_editable[3] = false;
        this.keyCol = 0;
        ((String[])this.dados.elementAt((int)0))[0] = "S1";
        ((String[])this.dados.elementAt((int)1))[0] = "95";
        ((String[])this.dados.elementAt((int)2))[0] = "91";
        ((String[])this.dados.elementAt((int)3))[0] = "T1";
        ((String[])this.dados.elementAt((int)0))[1] = "Subtotal das A\u00e7\u00f5es";
        ((String[])this.dados.elementAt((int)1))[1] = "Despesas com Recursos Humanos";
        ((String[])this.dados.elementAt((int)2))[1] = "Despesas Gerais do Benefici\u00e1rio";
        ((String[])this.dados.elementAt((int)3))[1] = "Total";
        this.handler.set_col_text(1, 0.304, "R");
        this.handler.set_col_text(2, 0.175, "R");
        this.handler.set_col_text(3, 0.175, "R");
        this.handler.set_col_text(4, 0.175, "R");
        this.handler.set_col_text(5, 0.175, "R");
        ((CHTabQuadro)this.handler).row_autocalc[3] = "$soma(+0,+1,+2)";
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.startsWith("valor_f") && (nRow == 1 || nRow == 2)) {
            String zero = CBData.Params.zero_ano(colname);
            double sum = _lib.round(_lib.to_double(this.getColValue(colname, nRow)));
            int target = nRow == 1 ? 2 : 1;
            CBData.DespFinParam.setColValue(colname, target, sum == 0.0 ? zero : String.valueOf(sum));
            CBData.DespFinParam.on_update(colname, target, sum == 0.0 ? zero : String.valueOf(sum));
        }
        if (CBData.Params.aviso.equals("14:1") && colname.startsWith("valor_f") && nRow == 0) {
            double dgb = _lib.round(_lib.to_double(v) * 0.04);
            this.setColValue(colname, 2, String.valueOf(dgb));
            this.on_update(colname, 2, String.valueOf(dgb));
        }
        if (colname.startsWith("valor_")) {
            String f1 = this.getColValue("valor_f1", nRow);
            String f2 = this.getColValue("valor_f2", nRow);
            String f3 = this.getColValue("valor_f3", nRow);
            if ((String.valueOf(f1) + f2 + f3).equals("")) {
                this.setColValue("valor_tt", nRow, "");
            } else {
                double total = _lib.to_double(f1) + _lib.to_double(f2) + _lib.to_double(f3);
                this.setColValue("valor_tt", nRow, total == 0.0 ? "0" : String.valueOf(_lib.round(total)));
            }
        }
        this.autocalc2(true, true, 2);
        this.handler.j.revalidate();
        this.handler.j.repaint();
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Despesas Financeiras do Projeto");
        }
        StringBuffer mask = new StringBuffer("--???-");
        int n_anos_param = _lib.to_int(CBData.Params.getByName((String)"n_anos").v);
        mask.setCharAt(2, (char)(CBData.Params.anos < 1 ? 45 : (n_anos_param < 1 ? 78 : 82)));
        mask.setCharAt(3, (char)(CBData.Params.anos < 2 ? 45 : (n_anos_param < 2 ? 78 : 82)));
        mask.setCharAt(4, (char)(CBData.Params.anos < 3 ? 45 : (n_anos_param < 3 ? 78 : 82)));
        int[] nArray = new int[]{};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            if (!this.isRowEmpty(j)) {
                TabError[] e = this.isIncompletAll(j, mask.toString());
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg(e[ii], e[ii].msg(String.valueOf(this.getColValue("rubrica_d", j)) + ": %T - %o", String.valueOf(this.getColValue("rubrica_d", j)) + ": %T - %n")));
                    ++ii;
                }
            }
            ++n2;
        }
        int i = 0;
        while (i < this.cols.length) {
            if (this.cols[i].col_tag.startsWith("valor_fake") && _lib.round(_lib.to_double(this.getColValue(this.cols[i].col_tag, 2))) > _lib.round(_lib.to_double(this.getColValue(this.cols[i].col_tag, 0)) * 0.04)) {
                err_list.add_msg(new CHValid_Msg(String.valueOf(this.cols[i].col_name2) + " - '" + this.getColValue("rubrica_d", 2) + "' n\u00e3o pode ser superior a 4% de '" + this.getColValue("rubrica_d", 0) + "'", 2, i));
            }
            ++i;
        }
        if (CBData.Params.aviso.equals("12:3")) {
            if (_lib.to_double(this.getColValue("valor_f1", 0)) < _lib.to_double(this.getColValue("valor_f1", 3))) {
                err_list.add_msg(new CHValid_Msg("Ano 1: As despesas com garantias banc\u00e1rias n\u00e3o podem ser superiores ao subtotal das a\u00e7\u00f5es. "));
            }
            if (CBData.Params.anos > 1 && _lib.to_double(this.getColValue("valor_f2", 0)) < _lib.to_double(this.getColValue("valor_f2", 3))) {
                err_list.add_msg(new CHValid_Msg("Ano 2: As despesas com garantias banc\u00e1rias n\u00e3o podem ser superiores ao subtotal das a\u00e7\u00f5es."));
            }
            if (CBData.Params.anos > 2 && _lib.to_double(this.getColValue("valor_f3", 0)) < _lib.to_double(this.getColValue("valor_f3", 3))) {
                err_list.add_msg(new CHValid_Msg("Ano 3: As despesas com garantias banc\u00e1rias n\u00e3o podem ser superiores ao subtotal das a\u00e7\u00f5es."));
            }
        }
        return err_list;
    }

    void clearRow(int i) {
        if (((CHTabQuadro)this.handler).row_editable[i]) {
            super.clearRow(i);
        } else {
            int j = 2;
            while (j < this.cols.length) {
                String s;
                ((String[])this.dados.elementAt((int)i))[j] = s = CBData.Params.anos > (j - 2) % 3 ? "0" : "";
                this.on_update(this.cols[j].col_tag, i, s);
                ++j;
            }
        }
    }
}

